/*
 * Decompiled with CFR 0.152.
 */
package org.e2etrace.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.e2etrace.config.ITraceConfig;
import org.e2etrace.trace.ITraceStepId;

public class PropertiesTraceConfig
implements ITraceConfig {
    private static final Log log = LogFactory.getLog(PropertiesTraceConfig.class);
    private static final String KEY_ENABLETRACE = "global.enabletrace";
    private static final String KEY_RELOADINTERVAL = "global.reloadinterval";
    private static final String KEY_IDPREFIX = "id.";
    private String fileName;
    private boolean enabled;
    private boolean configIsDirty;
    private HashSet disabledForId;
    private long reloadInterval;
    private long lastReload;

    public boolean isTraceEnabled() {
        this.reloadifIntervalExpired();
        return this.enabled;
    }

    public boolean isTraceEnabledForId(ITraceStepId id) {
        boolean ret = true;
        this.reloadifIntervalExpired();
        if (this.disabledForId.contains(id.asString())) {
            ret = false;
        }
        return ret;
    }

    public void loadConfigFile(String fileName) throws IOException {
        this.fileName = fileName;
        this.configIsDirty = true;
        this.reloadConfiguration();
    }

    private void reloadifIntervalExpired() {
        if (this.reloadInterval > 0L && System.currentTimeMillis() / 1000L - this.lastReload >= this.reloadInterval) {
            try {
                this.configIsDirty = true;
                this.reloadConfiguration();
            }
            catch (IOException e) {
                log.error((Object)"Cannot reload configuration file. Will use the already loaded values instead.", (Throwable)e);
            }
        }
    }

    private synchronized void reloadConfiguration() throws IOException {
        if (!this.configIsDirty) {
            return;
        }
        Properties loadedConfig = this.locateAndLoadProperties();
        this.enabled = this.getPropertyAsBoolean(loadedConfig, KEY_ENABLETRACE, true);
        this.reloadInterval = this.getPropertyAsLong(loadedConfig, KEY_RELOADINTERVAL, 0L);
        Enumeration<Object> e = loadedConfig.keys();
        this.disabledForId = new HashSet();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(KEY_IDPREFIX)) continue;
            String id = key.substring(key.indexOf(".") + 1);
            boolean idEnabled = this.getPropertyAsBoolean(loadedConfig, key, true);
            if (idEnabled) continue;
            this.disabledForId.add(id);
        }
        this.lastReload = System.currentTimeMillis() / 1000L;
        this.configIsDirty = false;
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded configuration file " + this.fileName));
            log.info((Object)("Tracing is now " + (this.enabled ? "enabled" : "disabled")));
            log.info((Object)("Reload interval is now " + this.reloadInterval + " seconds"));
            log.info((Object)("Tracing has been disabled for " + this.disabledForId.size() + " ids"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties locateAndLoadProperties() throws IOException {
        Properties loadedConfig;
        block6: {
            InputStream is = null;
            loadedConfig = new Properties();
            try {
                ClassLoader ctxLoader;
                is = PropertiesTraceConfig.class.getResourceAsStream(this.fileName);
                if (is == null && (is = (ctxLoader = Thread.currentThread().getContextClassLoader()).getResourceAsStream(this.fileName)) == null) {
                    is = new FileInputStream(this.fileName);
                }
                if (is != null) {
                    loadedConfig.load(is);
                    break block6;
                }
                throw new IOException("Cannot find or open file " + this.fileName);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        return loadedConfig;
    }

    private boolean getPropertyAsBoolean(Properties loadedConfig, String key, boolean def) {
        boolean ret = def;
        String retValue = loadedConfig.getProperty(key);
        if (retValue != null) {
            ret = new Boolean(retValue);
        }
        return ret;
    }

    private long getPropertyAsLong(Properties loadedConfig, String key, long def) {
        long ret = def;
        String retValue = loadedConfig.getProperty(key);
        if (retValue != null) {
            ret = new Long(retValue);
        }
        return ret;
    }
}

