/*
 * Decompiled with CFR 0.152.
 */
package org.e2etrace.formatter;

import java.io.IOException;
import java.io.Writer;
import org.e2etrace.formatter.ITraceFormatter;
import org.e2etrace.trace.ITraceSession;
import org.e2etrace.trace.ITraceStep;

public abstract class AbstractTraceFormatter
implements ITraceFormatter {
    protected AbstractTraceFormatter() {
    }

    protected abstract String formatSingleStep(ITraceStep var1, int var2);

    public void format(ITraceSession session, Writer toWriter) throws IOException {
        this.writeHeader(session, toWriter);
        if (session.getRootStep() != null) {
            this.writeSteps(session.getRootStep(), toWriter, 0);
        }
        this.writeFooter(session, toWriter);
    }

    protected String getNewLine() {
        return System.getProperty("line.separator");
    }

    protected abstract void writeFooter(ITraceSession var1, Writer var2) throws IOException;

    protected abstract void writeHeader(ITraceSession var1, Writer var2) throws IOException;

    protected void writeSteps(ITraceStep step, Writer toWriter, int level) throws IOException {
        if (step != null) {
            toWriter.write(this.formatSingleStep(step, level));
            ITraceStep[] childSteps = step.getChildren();
            ++level;
            for (int i = 0; i < childSteps.length; ++i) {
                this.writeSteps(childSteps[i], toWriter, level);
            }
        }
    }
}

