/*
 * Decompiled with CFR 0.152.
 */
package org.e2etrace.formatter;

import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import org.e2etrace.formatter.AbstractTraceFormatter;
import org.e2etrace.trace.ITraceSession;
import org.e2etrace.trace.ITraceStep;
import org.e2etrace.trace.TraceSessionRootStep;
import org.e2etrace.trace.TraceSessionRootStepId;

public class CSVTraceFormatter
extends AbstractTraceFormatter {
    private static final String CSV_DELIM = ",";
    private static final String PATH_DELIM = "|";

    protected String formatSingleStep(ITraceStep step, int level) {
        StringBuffer output = new StringBuffer();
        StringBuffer path = new StringBuffer();
        ITraceStep ts = step;
        String threadName = null;
        Stack<String> stepHierarchy = new Stack<String>();
        do {
            stepHierarchy.push(ts.getId().asString());
            if (!(ts instanceof TraceSessionRootStep) || threadName != null) continue;
            TraceSessionRootStepId rootId = (TraceSessionRootStepId)ts.getId();
            threadName = rootId.getThreadName();
        } while ((ts = ts.getParent()) != null);
        while (!stepHierarchy.empty()) {
            path.append((String)stepHierarchy.pop());
            if (stepHierarchy.empty()) continue;
            path.append(PATH_DELIM);
        }
        output.append(step.getId().asString());
        output.append(CSV_DELIM);
        output.append(path.toString());
        output.append(CSV_DELIM);
        output.append(threadName);
        output.append(CSV_DELIM);
        output.append(step.getDuration());
        output.append(CSV_DELIM);
        output.append(step.getIsolatedDuration());
        output.append(this.getNewLine());
        return output.toString();
    }

    protected void writeFooter(ITraceSession session, Writer toWriter) {
    }

    protected void writeHeader(ITraceSession session, Writer toWriter) throws IOException {
        toWriter.write("id,path,threadname,duration,isolated_duration");
        toWriter.write(this.getNewLine());
    }
}

