/*
 * Decompiled with CFR 0.152.
 */
package org.e2etrace.formatter;

import java.io.Writer;
import org.e2etrace.formatter.AbstractTraceFormatter;
import org.e2etrace.trace.ITraceSession;
import org.e2etrace.trace.ITraceStep;
import org.e2etrace.trace.TraceSessionRootStep;
import org.e2etrace.trace.TraceSessionRootStepId;

public class PlainTextTraceFormatter
extends AbstractTraceFormatter {
    protected String formatSingleStep(ITraceStep step, int level) {
        StringBuffer output = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            output.append("  ");
        }
        if (step instanceof TraceSessionRootStep) {
            TraceSessionRootStepId rootId = (TraceSessionRootStepId)step.getId();
            output.append(">> ");
            output.append(rootId.asString());
            output.append(" [" + rootId.getThreadName() + "]");
        } else {
            output.append(step.getId().asString());
        }
        output.append(" (");
        output.append("Total: ");
        output.append(step.getDuration());
        output.append("ms, ");
        if (step.getIsolatedDuration() >= 0L) {
            output.append("Step: ");
            output.append(step.getIsolatedDuration());
            output.append("ms");
        } else {
            output.append("n/a");
        }
        output.append(")");
        output.append(this.getNewLine());
        return output.toString();
    }

    protected void writeFooter(ITraceSession session, Writer toWriter) {
    }

    protected void writeHeader(ITraceSession session, Writer toWriter) {
    }
}

