/*
 * Decompiled with CFR 0.152.
 */
package org.e2etrace.timer;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.e2etrace.timer.DefaultTimer;
import org.e2etrace.timer.ExactTimer;
import org.e2etrace.timer.ITimer;
import org.e2etrace.timer.ITimerFactory;

public class DefaultTimerFactory
implements ITimerFactory {
    private static final Log log = LogFactory.getLog(DefaultTimerFactory.class);
    private static final boolean supportsExactMeasuring = DefaultTimerFactory.supportsNanoTime();
    private Class timerType;

    public DefaultTimerFactory() {
        if (supportsExactMeasuring) {
            this.setTimerType(ExactTimer.class);
        } else {
            this.setTimerType(DefaultTimer.class);
        }
    }

    public DefaultTimerFactory(Class timerType) {
        this.setTimerType(timerType);
    }

    public ITimer newInstance() {
        ITimer timer = null;
        try {
            timer = (ITimer)this.timerType.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Error creating a new Timer of type " + this.timerType.getName() + ". Will create a DefaultTimer instead."), (Throwable)e);
            timer = new DefaultTimer();
        }
        return timer;
    }

    public void setTimerType(Class timerType) {
        this.timerType = timerType;
    }

    public Class getTimerType() {
        return this.timerType;
    }

    private static boolean supportsNanoTime() {
        boolean ret = false;
        Method[] methods = System.class.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals("nanoTime")) continue;
            ret = true;
            break;
        }
        if (ret) {
            log.info((Object)"This VM supports exact time measuring using System.nanoTime()");
        } else {
            log.warn((Object)"This VM only supports only System.currentTimeMillis(). This may lead to inaccurate results.");
        }
        return ret;
    }
}

