/*
 * Decompiled with CFR 0.152.
 */
package org.e2etrace.trace;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.e2etrace.config.DefaultTraceConfig;
import org.e2etrace.config.ITraceConfig;
import org.e2etrace.config.PropertiesTraceConfig;
import org.e2etrace.trace.ITraceSession;
import org.e2etrace.trace.ITraceSessionManager;
import org.e2etrace.trace.NoopTraceSession;

public abstract class AbstractTraceSessionManager
implements ITraceSessionManager {
    private static final Log log = LogFactory.getLog(AbstractTraceSessionManager.class);
    private static final String CONFIG_PROPERTY = "e2etrace.configuration";
    private ITraceConfig config = this.initConfiguration();
    private ITraceSession noopSession = new NoopTraceSession();

    protected AbstractTraceSessionManager() {
    }

    private ITraceConfig initConfiguration() {
        ITraceConfig initConfig = null;
        String configFile = System.getProperty(CONFIG_PROPERTY);
        if (configFile != null) {
            try {
                if (configFile.endsWith(".properties")) {
                    PropertiesTraceConfig propConfig = new PropertiesTraceConfig();
                    propConfig.loadConfigFile("/" + configFile);
                    initConfig = propConfig;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error while initializing e2etrace configuration! Will use default configuration instead.", (Throwable)e);
            }
        }
        if (initConfig == null) {
            initConfig = new DefaultTraceConfig();
        }
        return initConfig;
    }

    protected abstract ITraceSession requestCurrentSession();

    protected abstract void assignCurrentSession(ITraceSession var1);

    public final void setConfig(ITraceConfig config) {
        this.config = config;
    }

    public final ITraceConfig getConfig() {
        return this.config;
    }

    public ITraceSession getCurrentSession() {
        ITraceSession currentSession;
        if (this.getConfig().isTraceEnabled()) {
            currentSession = this.requestCurrentSession();
            if (currentSession == null) {
                currentSession = this.noopSession;
            }
        } else {
            currentSession = this.noopSession;
        }
        return currentSession;
    }

    public void setCurrentSession(ITraceSession session) {
        if (session.getRootStep() == null || !this.getConfig().isTraceEnabledForId(session.getRootStep().getId())) {
            this.assignCurrentSession(this.noopSession);
        } else {
            session.setConfig(this.getConfig());
            this.assignCurrentSession(session);
        }
    }
}

