/*
 * Decompiled with CFR 0.152.
 */
package org.e2etrace.trace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.e2etrace.trace.ITraceStep;
import org.e2etrace.trace.ITraceStepId;

public abstract class AbstractTraceStep
implements ITraceStep,
Serializable {
    private static final long serialVersionUID = 1L;
    private ITraceStepId id;
    protected List children;
    private ITraceStep parent;

    public AbstractTraceStep(ITraceStepId id) {
        this.id = id;
    }

    public ITraceStepId getId() {
        return this.id;
    }

    public void addChild(ITraceStep child) {
        if (child == null) {
            return;
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        child.setParent(this);
    }

    public ITraceStep[] getChildren() {
        ITraceStep[] steps = new ITraceStep[]{};
        if (this.children != null) {
            steps = new ITraceStep[this.children.size()];
            for (int i = 0; i < steps.length; ++i) {
                steps[i] = (ITraceStep)this.children.get(i);
            }
        }
        return steps;
    }

    public ITraceStep getParent() {
        return this.parent;
    }

    public void setParent(ITraceStep parent) {
        this.parent = parent;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id == null ? 0 : this.id.hashCode());
        return hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        AbstractTraceStep castedObj = (AbstractTraceStep)o;
        return this.id == null ? castedObj.id == null : this.id.equals(castedObj.id);
    }

    public abstract void enter() throws IllegalStateException;

    public abstract long getDuration();

    public abstract long getIsolatedDuration();

    public abstract boolean isActive();

    public abstract void leave() throws IllegalStateException;

    protected void leaveAllChildren() {
        if (this.children != null) {
            for (ITraceStep element : this.children) {
                if (!element.isActive()) continue;
                element.leave();
            }
        }
    }
}

