/*
 * Decompiled with CFR 0.152.
 */
package org.e2etrace.trace;

import org.e2etrace.config.DefaultTraceConfig;
import org.e2etrace.config.ITraceConfig;
import org.e2etrace.trace.ITraceSession;
import org.e2etrace.trace.ITraceStep;
import org.e2etrace.trace.ITraceStepFactory;
import org.e2etrace.trace.ITraceStepId;
import org.e2etrace.trace.MethodTraceStepId;
import org.e2etrace.trace.SimpleTraceStepId;
import org.e2etrace.trace.TraceSessionRootStep;
import org.e2etrace.trace.TraceSessionRootStepId;

public class DefaultTraceSession
implements ITraceSession {
    private ITraceStep root;
    private ITraceStep current;
    private ITraceStepFactory stepFactory;
    private ITraceConfig tc;

    public DefaultTraceSession(String sessionId, ITraceStepFactory stepFactory) {
        this.current = this.root = new TraceSessionRootStep(new TraceSessionRootStepId(sessionId));
        this.stepFactory = stepFactory;
        this.tc = new DefaultTraceConfig();
    }

    public void enterStep(Class clazz, String method) {
        if (this.tc.isTraceEnabled()) {
            this.enterStep(new MethodTraceStepId(clazz, method));
        }
    }

    public void leaveStep(Class clazz, String method) {
        if (this.tc.isTraceEnabled()) {
            this.leaveStep(new MethodTraceStepId(clazz, method));
        }
    }

    public void enterStep(String id) {
        if (this.tc.isTraceEnabled()) {
            this.enterStep(new SimpleTraceStepId(id));
        }
    }

    public void leaveStep(String id) {
        if (this.tc.isTraceEnabled()) {
            this.leaveStep(new SimpleTraceStepId(id));
        }
    }

    public void enterStep(ITraceStepId id) {
        if (this.tc.isTraceEnabledForId(id)) {
            ITraceStep step = this.stepFactory.newInstance(id);
            this.current.addChild(step);
            this.current = step;
            step.enter();
        }
    }

    public void leaveStep(ITraceStepId id) {
        if (this.tc.isTraceEnabledForId(id)) {
            ITraceStep step = this.current;
            if (!this.current.getId().equals(id)) {
                for (step = this.current.getParent(); step != null && step != this.root && !step.getId().equals(id); step = step.getParent()) {
                }
            }
            if (step != null) {
                step.leave();
            }
            if (step != this.root && step != null) {
                this.current = step.getParent();
            }
        }
    }

    public ITraceStep getRootStep() {
        return this.root;
    }

    public long getDuration() {
        long duration = 0L;
        ITraceStep[] rootChildren = this.root.getChildren();
        for (int i = 0; i < rootChildren.length; ++i) {
            duration += rootChildren[i].getDuration();
        }
        return duration;
    }

    public void setConfig(ITraceConfig tc) {
        this.tc = tc;
    }

    public ITraceConfig getConfig() {
        return this.tc;
    }

    public ITraceStep getCurrentStep() {
        return this.current;
    }
}

