/*
 * Decompiled with CFR 0.152.
 */
package org.e2etrace.trace;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.e2etrace.timer.ITimer;
import org.e2etrace.timer.ITimerFactory;
import org.e2etrace.trace.AbstractTraceStep;
import org.e2etrace.trace.ITraceStep;
import org.e2etrace.trace.ITraceStepId;

public class DefaultTraceStep
extends AbstractTraceStep {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DefaultTraceStep.class);
    private long duration = 0L;
    private boolean active = false;
    private transient ITimer timer;
    private transient ITimerFactory timerFactory;

    DefaultTraceStep(ITraceStepId id, ITimerFactory timerFactory) {
        super(id);
        if (timerFactory == null) {
            throw new IllegalArgumentException("timerFactory must not be null");
        }
        this.timerFactory = timerFactory;
    }

    public void enter() {
        if (this.isActive()) {
            log.warn((Object)("enter() has been called before for trace step '" + this.getId().asString() + "'"));
            return;
        }
        if (this.timerFactory == null) {
            log.warn((Object)"enter() cannot be invoked after Serialization of the trace step");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(">>> Entering " + this.getId().asString()));
        }
        this.timer = this.timerFactory.newInstance();
        this.timer.start();
        this.active = true;
    }

    public void leave() {
        if (this.timerFactory == null) {
            log.warn((Object)"leave() cannot be invoked after Serialization of the trace step");
            return;
        }
        if (!this.isActive()) {
            log.warn((Object)("leave() has been called before OR leave() has been called without prior enter() for trace step '" + this.getId().asString() + "'"));
            return;
        }
        this.leaveAllChildren();
        this.duration = this.timer.measure();
        this.active = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("<<< Leaving " + this.getId().asString() + " (" + this.duration + "ms)"));
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getIsolatedDuration() {
        long duration = this.getDuration();
        if (this.children != null) {
            for (ITraceStep element : this.children) {
                duration -= element.getDuration();
            }
        }
        if (duration < 0L) {
            duration = -1L;
        }
        return duration;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[DefaultTraceStep:");
        buffer.append(" id: ");
        buffer.append(this.getId());
        buffer.append(" duration: ");
        buffer.append(this.duration);
        buffer.append(" parent: ");
        buffer.append(this.getParent());
        buffer.append("]");
        return buffer.toString();
    }
}

