/*
 * Decompiled with CFR 0.152.
 */
package org.e2etrace.trace;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.e2etrace.trace.AbstractTraceSessionManager;
import org.e2etrace.trace.ITraceSession;

public class ThreadedTraceSessionManager
extends AbstractTraceSessionManager {
    private static final ThreadedTraceSessionManager instance = new ThreadedTraceSessionManager();
    private Map sessionCache = Collections.synchronizedMap(new WeakHashMap());

    public static ThreadedTraceSessionManager getInstance() {
        return instance;
    }

    private ThreadedTraceSessionManager() {
    }

    protected ITraceSession requestCurrentSession() {
        return (ITraceSession)this.sessionCache.get(Thread.currentThread());
    }

    protected void assignCurrentSession(ITraceSession session) {
        this.sessionCache.put(Thread.currentThread(), session);
    }

    public void releaseCurrentSession() {
        this.sessionCache.remove(Thread.currentThread());
    }
}

